/*
 * Decompiled with CFR 0.152.
 */
package com.instalments.data;

import com.dto.LoginDto;
import com.instalments.data.InstalmentEntity;
import com.instalments.domain.InstalmentDto;
import com.instalments.domain.InstalmentMapper;
import com.instalments.domain.InstalmentSettleDto;
import com.instalments.domain.use_case.InstalmentBulkInsert;
import com.security.SecurityConstants;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class InstalmentDao {
    private final DbConnection dbConnection;

    public List<InstalmentDto> getInstalments(@Language(value="SQL") String whereStr) {
        String sql = this.makeGetSql(whereStr);
        LoginDto login = this.dbConnection.setToken();
        return this.dbConnection.getJdbcTemplate(login).query(sql, (RowMapper)new InstalmentMapper());
    }

    @Language(value="SQL")
    @NotNull
    private String makeGetSql(@Language(value="SQL") String whereStr) {
        LoginDto login = SecurityConstants.loadToken();
        String myHolooSelect = this.getMyHolooSelect(login);
        return "SELECT [C_Code] customerCode, Convert(nvarchar(10), [D_Par_Ghest], 111) dueDate, \n [Index], [Mablagh_Ghest] toPayAmount, [Gh_Vosol] isSettled, [Sh_Gh] instalmentNumber, \n Convert(nvarchar(10), [Dar_Ghest], 111) settleDate, \n Convert(nvarchar(10), [Dar_Ghest], 108) settleTime, [Tozihat] description, \n [Dar_Par] isOurPayment, [gh_id] loanCode, [Sanad_Dar] docCode, \n [SanadTakhir] overdueDocumentCode, [PriceSood] interestPrice, gh_babat regardedTo, \n [CommentVosol] settleDescription, [Jarimeh] finePrice, [FewGhest] instalmentCount, \n [Num_Fact] numFact, [mab_Col] totalPrice, [Cash_Name] cashName, \n [Ghest_Comment1] desc1, [Ghest_Comment2] desc2, \n [Sanad_Sood] interestDocCode , [D_Par_GhestStr] dueDateJalali, \n Convert(nvarchar(10), [ExportDate], 111) issueDate" + myHolooSelect + "FROM [GHEST] \nWHERE 1 = 1 \n" + (ConvertStr.isNullOrEmpty((String)whereStr) ? "" : " AND " + whereStr);
    }

    @Language(value="SQL")
    private String getMyHolooSelect(LoginDto login) {
        if (login.getIsMyHoloo().booleanValue()) {
            return ", \n[cash], [cash_sarfasl] cashHeading, [pos], [pos_sarfasl] posHeading, [discount], \n [discount_sarfasl] discountHeading, [userCodeInc], [with_sanad] withDoc \n";
        }
        return ", \n -1 [cash], null cashHeading, -1 [pos], null posHeading, -1 [discount], \n null discountHeading, -1 [userCodeInc], null withDoc \n";
    }

    public void settle(InstalmentSettleDto settleDto) {
        LoginDto login = this.dbConnection.setToken();
        String myHolooParts = this.getMyHolooUpdates(settleDto, login);
        String sql = "UPDATE GHEST SET GH_VOSOL = 1, DAR_GHEST = ?, sanad_dar = ?,  Mablagh_Ghest = " + (settleDto.calcInstalmentAmount() == -1.0 ? "Mablagh_Ghest" : Double.valueOf(settleDto.calcInstalmentAmount())) + ", \n CommentVosol = ? " + myHolooParts + " \n WHERE [index] = ?";
        this.dbConnection.getJdbcTemplate(login).update(sql, new Object[]{settleDto.getSettleDate() + (login.getIsMyHoloo() != false ? " " + settleDto.getSettleTime() : ""), settleDto.getDocCode() == 0L ? null : Long.valueOf(settleDto.getDocCode()), ConvertStr.nullSafeString((String)settleDto.getComment()), settleDto.getIndex()});
    }

    private String getMyHolooUpdates(InstalmentSettleDto settleDto, LoginDto login) {
        if (!login.getIsMyHoloo().booleanValue()) {
            return "";
        }
        return ", [IsChange] = 1, [UserCodeInc] = " + this.getUserCode(settleDto, login) + ", \n[cash] = " + settleDto.getCash() + ", \n[cash_sarfasl] = " + ConvertStr.toQuotedSqlStr((String)settleDto.getCashHeading()) + ", \n[pos_sarfasl] = " + ConvertStr.toQuotedSqlStr((String)settleDto.getPosHeading()) + ", \n[pos] = " + settleDto.getPos() + ", \n[discount] = " + settleDto.getDiscount() + ", \n[discount_sarfasl] = " + ConvertStr.toQuotedSqlStr((String)settleDto.getDiscountHeading()) + ", \n[with_sanad] = " + ConvertStr.boolToBit((Boolean)settleDto.isWithDoc());
    }

    private long getUserCode(InstalmentSettleDto settleDto, LoginDto login) {
        return settleDto.getUserCode() == null ? (long)login.getUserCodeInc() : settleDto.getUserCode();
    }

    public void batchInsertInstalments(LoginDto loginDto, List<InstalmentEntity> entityList) {
        new InstalmentBulkInsert(this.dbConnection).bulkInsert(loginDto, entityList);
    }

    public InstalmentDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

